//Calculation of Transmission Line parameters using Nominal-T method//
//This program requires user input. Sample problem with user input and result are available in the result file//
//Scilab Version 5.5.2 ; OS:Windows
clc;
clear;
pl=input('Enter the power supplied to the load:');
vr=input('Enter the receiving end voltage:');
pf=input('Enter the power factor:');
spf=sin(acos(pf));
z=input('Enter the series impedance value of single conductor:');
y=input('Enter the shunt admittance value:');
e=(z*y)/2;
a=(1+e);               //calculation of transmission line parameters
b=z*(1+e/2);
c=y;
d=a;
disp(d,c,b,a,'The values of ABCD parameters respectively are')
vrph=vr/sqrt(3);      //receiving end voltage per phase
ir=pl/(sqrt(3)*vr*pf);       //receiving end current
irv=ir*(pf-%i*spf);          // receiving end current in vector form
vsph=(a*vrph+b*irv);         //sending end voltage per phase
vsh=abs(vsph);               // magnitude of sending end voltage per phase
reg=((abs(vsh/a)-abs(vrph))/vrph)*100;      //calculation of percentage regulation 
disp(reg,'regulation of the line is')


//SAMPLE INPUT:
//Enter the power supplied to the load:30e6
//Enter the receiving end voltage:132e3
//Enter the power factor:0.85
//Enter the series impedance value of single conductor:20+52*%i
//Enter the shunt admittance value:315e-6*%i
 
 
 //OUTPUT:
 //The values of ABCD parameters respectively are   
 
   // 0.99181 + 0.00315i  
 
    //19.8362 + 51.81856i  
 
    //0.000315i  
 
//    0.99181 + 0.00315i  
 
 //regulation of the line is   
 
   // 9.2540724 
